<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/includes/functions.php';
require_once __DIR__ . '/api/esim-api.php';

$pageTitle = 'تکمیل خرید';
$error = '';
$noAuthRedirect = true; // Checkout doesn't require login initially
$isLoggedIn = isLoggedIn();

// Get package and country from URL
$packageCode = $_GET['package'] ?? '';
$countryCode = $_GET['country'] ?? '';

if (empty($packageCode) || empty($countryCode)) {
    header('Location: /');
    exit;
}

// Handle purchase confirmation (when user is logged in)
if (isset($_POST['confirm_purchase']) && $isLoggedIn) {
    try {
        $api = new eSIMAPI();
        $package = $api->getPackageByCode($packageCode);
        
        if (!$package) {
            $allPackages = $api->getAllPackages();
            if ($allPackages && isset($allPackages['obj']['packageList'])) {
                foreach ($allPackages['obj']['packageList'] as $pkg) {
                    if ($pkg['packageCode'] == $packageCode) {
                        $package = $pkg;
                        break;
                    }
                }
            }
        }
        
        if ($package) {
            $priceUsd = $package['price'] / 10000;
            $volumeGB = round($package['volume'] / 1073741824, 1);
            $dataDisplay = $volumeGB . ' GB';
            
            $countries = require __DIR__ . '/data/countries.php';
            $countryName = $countryCode;
            foreach ($countries as $country) {
                if ($country['iso'] == $countryCode) {
                    $countryName = $country['name'];
                    break;
                }
            }
            
            $orderId = createOrder($_SESSION['user_id'], [
                'country_code' => $countryCode,
                'country_name' => $countryName,
                'package_name' => $package['name'],
                'package_code' => $packageCode,
                'data_amount' => $dataDisplay,
                'validity_days' => (int)$package['duration']
            ], $priceUsd);
            
            if ($orderId) {
                header('Location: /proxy-payment.php?order=' . $orderId);
                exit;
            } else {
                $error = 'خطا در ایجاد سفارش';
            }
        }
    } catch (Exception $e) {
        $error = 'خطا: ' . $e->getMessage();
    }
}

// Get package details from API
try {
    $api = new eSIMAPI();
    $package = $api->getPackageByCode($packageCode);
    
    if (!$package) {
        $allPackages = $api->getAllPackages();
        if ($allPackages && isset($allPackages['obj']['packageList'])) {
            foreach ($allPackages['obj']['packageList'] as $pkg) {
                if ($pkg['packageCode'] == $packageCode) {
                    $package = $pkg;
                    break;
                }
            }
        }
    }
    
    if (!$package) {
        $error = 'بسته مورد نظر یافت نشد';
    }
} catch (Exception $e) {
    $error = 'خطا در دریافت اطلاعات بسته: ' . $e->getMessage();
}

// Calculate prices
$priceUsd = 0;
$priceIrr = 0;
$volumeGB = 0;
$dataDisplay = '';

if ($package && !$error) {
    $priceUsd = $package['price'] / 10000;
    $priceIrr = usdToIrr($priceUsd);
    $volumeGB = round($package['volume'] / 1073741824, 1);
    $dataDisplay = $volumeGB . ' GB';
}

// Get country name
$countries = require __DIR__ . '/data/countries.php';
$countryName = $countryCode;
foreach ($countries as $country) {
    if ($country['iso'] == $countryCode) {
        $countryName = $country['name'];
        break;
    }
}

include __DIR__ . '/includes/header.php';
?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Vazirmatn:wght@400;500;600;700;800&display=swap');

body {
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif !important;
    background: linear-gradient(135deg, #CB1919 0%, #FF2929 100%);
    min-height: 100vh;
    padding: 40px 0;
}

.container {
    max-width: 800px;
    margin: 0 auto;
    padding: 0 20px;
}

.checkout-container {
    background: white;
    border-radius: 20px;
    padding: 30px;
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
}

.checkout-box {
    background: white;
    border-radius: 15px;
    padding: 30px;
    margin-bottom: 20px;
}

.checkout-box h2 {
    color: #1e293b;
    font-size: 1.8rem;
    font-weight: 800;
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.checkout-box h2 i {
    color: #CB1919;
}

.package-summary {
    display: flex;
    gap: 25px;
    align-items: center;
    margin-bottom: 25px;
    padding: 20px;
    background: linear-gradient(135deg, #f8f9ff 0%, #e8ecff 100%);
    border-radius: 15px;
}

.package-flag-large {
    width: 120px;
    height: 85px;
    border-radius: 12px;
    object-fit: cover;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
}

.package-info h3 {
    color: #1e293b;
    font-size: 1.5rem;
    font-weight: 800;
    margin-bottom: 15px;
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 15px;
}

.info-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 8px;
    padding: 12px;
    background: white;
    border-radius: 10px;
    font-weight: 700;
    color: #475569;
}

.info-item i {
    color: #CB1919;
    font-size: 1.3rem;
}

.info-item strong {
    font-size: 0.85rem;
    color: #94a3b8;
}

.price-box {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    padding: 25px;
    border-radius: 15px;
    text-align: center;
}

.price-box .label {
    font-size: 1.1rem;
    font-weight: 600;
    margin-bottom: 10px;
    opacity: 0.95;
}

.price-box .amount {
    font-size: 2.5rem;
    font-weight: 900;
}

.alert {
    padding: 15px 20px;
    border-radius: 12px;
    margin-bottom: 20px;
    display: flex;
    align-items: center;
    gap: 12px;
    font-weight: 600;
}

.alert-error {
    background: #fee;
    color: #c00;
    border: 2px solid #fcc;
}

.alert-success {
    background: #efe;
    color: #060;
    border: 2px solid #cfc;
}

.alert i {
    font-size: 1.3rem;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    font-weight: 700;
    color: #334155;
    margin-bottom: 8px;
    font-size: 1rem;
}

.form-group input {
    width: 100%;
    padding: 14px;
    border: 2px solid #e2e8f0;
    border-radius: 10px;
    font-size: 1.1rem;
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
    transition: all 0.3s ease;
    direction: ltr;
    text-align: center;
    font-weight: 700;
    letter-spacing: 2px;
}

.form-group input:focus {
    outline: none;
    border-color: #CB1919;
    box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
}

.form-group small {
    display: block;
    margin-top: 6px;
    color: #64748b;
    font-size: 0.9rem;
}

.btn {
    width: 100%;
    padding: 16px;
    border: none;
    border-radius: 12px;
    font-size: 1.1rem;
    font-weight: 800;
    cursor: pointer;
    transition: all 0.3s ease;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 10px;
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
}

.btn-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
}

.btn-primary:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
}

.btn-success {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
}

.btn-success:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 20px rgba(16, 185, 129, 0.4);
}

.btn-secondary {
    background: #e2e8f0;
    color: #475569;
    margin-top: 10px;
}

.btn-secondary:hover {
    background: #cbd5e1;
}

.btn:disabled {
    opacity: 0.5;
    cursor: not-allowed;
    background: #94a3b8 !important;
    transform: none !important;
}

/* eSIM Support Checkbox */
.esim-support-check {
    background: #fef3c7;
    border: 2px solid #fbbf24;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 20px;
}

.checkbox-container {
    display: flex;
    align-items: center;
    gap: 15px;
    cursor: pointer;
    user-select: none;
    font-size: 1.05rem;
    font-weight: 700;
    color: #92400e;
}

.checkbox-container input {
    position: absolute;
    opacity: 0;
    cursor: pointer;
    height: 0;
    width: 0;
}

.checkmark {
    position: relative;
    height: 28px;
    width: 28px;
    background-color: white;
    border: 3px solid #fbbf24;
    border-radius: 6px;
    flex-shrink: 0;
    transition: all 0.3s ease;
}

.checkbox-container:hover .checkmark {
    border-color: #f59e0b;
    box-shadow: 0 0 0 3px rgba(251, 191, 36, 0.2);
}

.checkbox-container input:checked ~ .checkmark {
    background-color: #10b981;
    border-color: #10b981;
}

.checkmark:after {
    content: "";
    position: absolute;
    display: none;
    left: 8px;
    top: 3px;
    width: 7px;
    height: 13px;
    border: solid white;
    border-width: 0 3px 3px 0;
    transform: rotate(45deg);
}

.checkbox-container input:checked ~ .checkmark:after {
    display: block;
}

.checkbox-text {
    display: flex;
    align-items: center;
    gap: 10px;
    flex: 1;
}

.checkbox-text i {
    color: #f59e0b;
    font-size: 1.3rem;
}

/* Auth Modal */
.auth-modal {
    display: none;
    position: fixed;
    z-index: 9999;
    left: 0;
    top: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.7);
    backdrop-filter: blur(5px);
    overflow-y: auto;
    -webkit-overflow-scrolling: touch;
}

.auth-modal-content {
    background-color: white;
    margin: 5% auto;
    padding: 40px;
    border-radius: 20px;
    width: 90%;
    max-width: 500px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.3);
    position: relative;
    animation: slideDown 0.3s ease;
    max-height: 90vh;
    overflow-y: auto;
}

@keyframes slideDown {
    from {
        opacity: 0;
        transform: translateY(-50px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

.auth-modal-close {
    position: absolute;
    left: 20px;
    top: 20px;
    font-size: 2rem;
    font-weight: bold;
    color: #94a3b8;
    cursor: pointer;
    transition: color 0.3s;
    line-height: 1;
}

.auth-modal-close:hover {
    color: #1e293b;
}

.auth-modal h3 {
    color: #1e293b;
    font-size: 1.8rem;
    font-weight: 800;
    margin-bottom: 25px;
    display: flex;
    align-items: center;
    gap: 12px;
}

.auth-modal h3 i {
    color: #667eea;
}

.step-indicator {
    background: #e0e7ff;
    padding: 12px 20px;
    border-radius: 10px;
    margin-bottom: 20px;
    text-align: center;
    font-weight: 700;
    color: #3730a3;
}

.otp-timer {
    text-align: center;
    margin: 15px 0;
    font-weight: 700;
    color: #667eea;
    font-size: 1.1rem;
}

.resend-link {
    text-align: center;
    margin-top: 15px;
}

.resend-link button {
    background: none;
    border: none;
    color: #667eea;
    font-weight: 700;
    cursor: pointer;
    text-decoration: underline;
    font-size: 1rem;
    font-family: 'Vazirmatn', Tahoma, Arial, sans-serif;
}

.resend-link button:hover {
    color: #764ba2;
}

.resend-link button:disabled {
    color: #94a3b8;
    cursor: not-allowed;
    text-decoration: none;
}

@media (max-width: 768px) {
    .checkout-container {
        padding: 10px;
    }
    
    .checkout-box {
        padding: 20px;
    }
    
    .package-summary {
        flex-direction: column;
        text-align: center;
    }
    
    .info-grid {
        grid-template-columns: 1fr;
    }
    
    .auth-modal {
        padding: 20px 0;
    }
    
    .auth-modal-content {
        width: 95%;
        padding: 25px 20px;
        margin: 20px auto;
        max-height: 85vh;
        border-radius: 15px;
    }
    
    .auth-modal h3 {
        font-size: 1.4rem;
    }
    
    .form-group input {
        padding: 12px;
    }
    
    .btn {
        padding: 12px;
        font-size: 1rem;
    }
    
    .esim-support-check {
        padding: 15px;
    }
    
    .checkbox-container {
        font-size: 0.95rem;
    }
    
    .checkmark {
        height: 24px;
        width: 24px;
    }
    
    .checkbox-text i {
        font-size: 1.1rem;
    }
}
</style>

<div class="container">
    <div class="checkout-container">
        <!-- Package Info -->
        <div class="checkout-box">
            <h2><i class="fas fa-sim-card"></i> eSIM انتخاب شده</h2>
            
            <?php if ($error && !$package): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i>
                    <?php echo $error; ?>
                </div>
                <div style="text-align: center; padding: 20px;">
                    <a href="/" class="btn btn-primary">بازگشت به صفحه اصلی</a>
                </div>
            <?php elseif ($package): ?>
                <div class="package-summary">
                    <img src="https://flagcdn.com/w160/<?php echo strtolower($countryCode); ?>.png" 
                         alt="<?php echo htmlspecialchars($countryName); ?>"
                         class="package-flag-large"
                         onerror="this.src='https://via.placeholder.com/120x85'">
                    
                    <div class="package-info">
                        <h3><?php echo htmlspecialchars($package['name']); ?></h3>
                        
                        <div class="info-grid">
                            <div class="info-item">
                                <strong>حجم داده</strong>
                                <i class="fas fa-database"></i>
                                <?php echo $dataDisplay; ?>
                            </div>
                            <div class="info-item">
                                <strong>مدت اعتبار</strong>
                                <i class="fas fa-calendar-alt"></i>
                                <?php echo $package['duration']; ?> روز
                            </div>
                            <div class="info-item">
                                <strong>نوع شبکه</strong>
                                <i class="fas fa-signal"></i>
                                <?php echo $package['speed'] ?? '4G/5G'; ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="price-box">
                    <div class="label">مبلغ قابل پرداخت</div>
                    <div class="amount"><?php echo formatPrice($priceIrr); ?> <span style="font-size: 20px;">تومان</span></div>
                </div>
            <?php endif; ?>
        </div>

        <!-- User Action -->
        <?php if ($isLoggedIn): ?>
            <div class="checkout-box">
                <h2><i class="fas fa-credit-card"></i> تکمیل خرید</h2>
                
                <div style="background: #e0e7ff; padding: 20px; border-radius: 12px; margin-bottom: 20px;">
                    <p style="margin: 0; color: #3730a3; font-weight: 700;">
                        <i class="fas fa-user"></i> 
                        <?php echo htmlspecialchars($_SESSION['mobile']); ?>
                    </p>
                </div>

                <?php if ($error): ?>
                    <div class="alert alert-error">
                        <i class="fas fa-exclamation-circle"></i>
                        <?php echo $error; ?>
                    </div>
                <?php endif; ?>

                <form method="POST" id="paymentForm">
                    <!-- Checkbox تایید پشتیبانی eSIM -->
                    <div class="esim-support-check">
                        <label class="checkbox-container">
                            <input type="checkbox" id="esimSupport" required>
                            <span class="checkmark"></span>
                            <span class="checkbox-text">
                                <i class="fas fa-mobile-alt"></i>
                                مطمئن هستم گوشی همراه من از eSIM پشتیبانی می‌کند
                            </span>
                        </label>
                        <small style="display: block; margin-top: 8px; color: #64748b; text-align: center;">
                            لطفاً قبل از خرید، از پشتیبانی گوشی خود از eSIM اطمینان حاصل کنید
                        </small>
                    </div>
                    
                    <button type="submit" name="confirm_purchase" class="btn btn-success" id="paymentBtn" disabled>
                        <i class="fas fa-credit-card"></i>
                        پرداخت <?php echo formatPrice($priceIrr); ?> تومان
                    </button>
                </form>
                
                <p style="text-align: center; margin-top: 20px; color: #64748b; font-size: 0.95rem; font-weight: 600;">
                    <i class="fas fa-shield-alt"></i>
                    پرداخت از طریق درگاه امن زرین‌پال
                </p>
            </div>
        <?php else: ?>
            <div class="checkout-box">
                <h2><i class="fas fa-user-circle"></i> ورود یا ثبت نام</h2>
                <p style="text-align: center; margin-bottom: 25px; color: #64748b; font-weight: 600;">
                    برای تکمیل خرید، لطفاً وارد حساب کاربری خود شوید
                </p>
                
                <button type="button" onclick="openAuthModal()" class="btn btn-primary">
                    <i class="fas fa-sign-in-alt"></i>
                    ورود / ثبت نام با OTP
                </button>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Auth Modal -->
<div id="authModal" class="auth-modal">
    <div class="auth-modal-content">
        <span class="auth-modal-close" onclick="closeAuthModal()">&times;</span>
        
        <div id="modalContent">
            <!-- Step 1: Mobile -->
            <div id="step-mobile">
                <h3><i class="fas fa-mobile-alt"></i> شماره موبایل</h3>
                
                <div id="modal-error" class="alert alert-error" style="display: none;"></div>
                <div id="modal-success" class="alert alert-success" style="display: none;"></div>
                
                <form id="mobileForm">
                    <div class="form-group">
                        <label>شماره موبایل</label>
                        <input type="text" id="mobile" name="mobile" required placeholder="09123456789" maxlength="11">
                        <small>می‌توانید از اعداد فارسی استفاده کنید</small>
                    </div>
                    <button type="submit" class="btn btn-primary" id="sendOtpBtn">
                        <i class="fas fa-paper-plane"></i>
                        ارسال کد تایید
                    </button>
                </form>
            </div>
            
            <!-- Step 2: OTP Verification -->
            <div id="step-otp" style="display: none;">
                <h3><i class="fas fa-shield-alt"></i> کد تایید</h3>
                
                <div class="step-indicator">
                    شماره موبایل: <span id="display-mobile"></span>
                </div>
                
                <div id="otp-error" class="alert alert-error" style="display: none;"></div>
                <div id="otp-success" class="alert alert-success" style="display: none;"></div>
                
                <form id="otpForm">
                    <div class="form-group">
                        <label>کد 4 رقمی ارسال شده</label>
                        <input type="text" id="otp" name="otp" required placeholder="1234" maxlength="4" pattern="[0-9]{4}">
                        <small>کد تایید به شماره موبایل شما ارسال شد</small>
                    </div>
                    
                    <div class="otp-timer" id="otpTimer">
                        <i class="fas fa-clock"></i>
                        <span id="timerDisplay">05:00</span>
                    </div>
                    
                    <button type="submit" class="btn btn-success" id="verifyOtpBtn">
                        <i class="fas fa-check-circle"></i>
                        تایید و ادامه
                    </button>
                    
                    <div class="resend-link">
                        <button type="button" id="resendBtn" onclick="resendOTP()" disabled>
                            ارسال مجدد کد
                        </button>
                    </div>
                    
                    <button type="button" class="btn btn-secondary" onclick="backToMobile()">
                        <i class="fas fa-arrow-right"></i>
                        تغییر شماره موبایل
                    </button>
                </form>
            </div>
            
        </div>
    </div>
</div>

<script>
// Convert Persian/Arabic numbers to English
function convertPersianToEnglish(str) {
    const persianNumbers = ['۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹'];
    const arabicNumbers = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
    const englishNumbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
    
    for (let i = 0; i < 10; i++) {
        str = str.replace(new RegExp(persianNumbers[i], 'g'), englishNumbers[i]);
        str = str.replace(new RegExp(arabicNumbers[i], 'g'), englishNumbers[i]);
    }
    return str;
}

// Apply Persian number conversion to inputs
document.addEventListener('DOMContentLoaded', function() {
    const inputs = document.querySelectorAll('input[type="text"]');
    inputs.forEach(function(input) {
        input.addEventListener('input', function(e) {
            const cursorPos = this.selectionStart;
            const oldValue = this.value;
            const newValue = convertPersianToEnglish(oldValue);
            if (oldValue !== newValue) {
                this.value = newValue;
                this.setSelectionRange(cursorPos, cursorPos);
            }
        });
    });
});

let currentPhone = '';
let otpTimer = null;
let timeLeft = 300; // 5 minutes

// Modal functions
function openAuthModal() {
    document.getElementById('authModal').style.display = 'block';
}

function closeAuthModal() {
    document.getElementById('authModal').style.display = 'none';
    backToMobile();
}

function backToMobile() {
    document.getElementById('step-mobile').style.display = 'block';
    document.getElementById('step-otp').style.display = 'none';
    clearTimer();
}

function showError(elementId, message) {
    const errorDiv = document.getElementById(elementId);
    errorDiv.innerHTML = '<i class="fas fa-exclamation-circle"></i> ' + message;
    errorDiv.style.display = 'flex';
}

function hideError(elementId) {
    document.getElementById(elementId).style.display = 'none';
}

function showSuccess(elementId, message) {
    const successDiv = document.getElementById(elementId);
    successDiv.innerHTML = '<i class="fas fa-check-circle"></i> ' + message;
    successDiv.style.display = 'flex';
}

function clearTimer() {
    if (otpTimer) {
        clearInterval(otpTimer);
        otpTimer = null;
    }
}

function startTimer() {
    timeLeft = 300; // Reset to 5 minutes
    document.getElementById('resendBtn').disabled = true;
    
    otpTimer = setInterval(function() {
        timeLeft--;
        
        const minutes = Math.floor(timeLeft / 60);
        const seconds = timeLeft % 60;
        document.getElementById('timerDisplay').textContent = 
            String(minutes).padStart(2, '0') + ':' + String(seconds).padStart(2, '0');
        
        if (timeLeft <= 0) {
            clearTimer();
            document.getElementById('resendBtn').disabled = false;
            document.getElementById('timerDisplay').textContent = 'منقضی شده';
        }
    }, 1000);
}

// Step 1: Send OTP
document.getElementById('mobileForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const mobile = convertPersianToEnglish(document.getElementById('mobile').value);
    const btn = document.getElementById('sendOtpBtn');
    
    hideError('modal-error');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال ارسال...';
    
    try {
        const response = await fetch('/api/send-otp.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ phone: mobile })
        });
        
        const data = await response.json();
        
        if (data.status === 'ok') {
            currentPhone = mobile;
            document.getElementById('display-mobile').textContent = mobile;
            document.getElementById('step-mobile').style.display = 'none';
            document.getElementById('step-otp').style.display = 'block';
            startTimer();
        } else {
            showError('modal-error', data.message);
        }
    } catch (error) {
        showError('modal-error', 'خطا در ارتباط با سرور');
    } finally {
        btn.disabled = false;
        btn.innerHTML = '<i class="fas fa-paper-plane"></i> ارسال کد تایید';
    }
});

// Step 2: Verify OTP
document.getElementById('otpForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const otp = convertPersianToEnglish(document.getElementById('otp').value);
    const btn = document.getElementById('verifyOtpBtn');
    
    hideError('otp-error');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال بررسی...';
    
    try {
        const response = await fetch('/api/verify-otp.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ phone: currentPhone, otp: otp })
        });
        
        const data = await response.json();
        
        if (data.status === 'ok' && data.verified) {
            if (data.new_user) {
                // کاربر جدید است - ثبت نام خودکار
                btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> در حال ثبت نام...';
                
                // ثبت نام خودکار کاربر
                try {
                    const registerResponse = await fetch('/api/register-user.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({ phone: currentPhone })
                    });
                    
                    const registerData = await registerResponse.json();
                    
                    if (registerData.status === 'ok') {
                        // Save token to localStorage and Cookie
                        if (registerData.token) {
                            localStorage.setItem('auth_token', registerData.token);
                            localStorage.setItem('user_data', JSON.stringify(registerData.user));
                            document.cookie = 'auth_token=' + registerData.token + '; path=/; max-age=' + (30*24*60*60) + '; SameSite=Lax';
                            console.log('✅ ثبت‌نام موفق - Token ذخیره شد');
                        }
                        
                        showSuccess('otp-success', 'ثبت نام و ورود موفقیت‌آمیز! در حال انتقال...');
                        
                        setTimeout(function() {
                            const token = registerData.token || localStorage.getItem('auth_token');
                            if (token) {
                                window.location.href = window.location.pathname + window.location.search + (window.location.search.includes('?') ? '&' : '?') + 'auth_token=' + token;
                            } else {
                                window.location.reload();
                            }
                        }, 1500);
                    } else {
                        showError('otp-error', registerData.message || 'خطا در ثبت نام');
                    }
                } catch (error) {
                    showError('otp-error', 'خطا در ثبت نام');
                }
            } else {
                // User logged in - save token
                if (data.token) {
                    // ذخیره در localStorage
                    localStorage.setItem('auth_token', data.token);
                    localStorage.setItem('user_data', JSON.stringify(data.user));
                    
                    // ذخیره در Cookie
                    document.cookie = 'auth_token=' + data.token + '; path=/; max-age=' + (30*24*60*60) + '; SameSite=Lax';
                    
                    console.log('✅ لاگین موفق - Token ذخیره شد:', data.token.substring(0, 20) + '...');
                    console.log('🍪 Cookie ست شد:', document.cookie.includes('auth_token='));
                }
                
                showSuccess('otp-success', 'ورود موفقیت‌آمیز! در حال انتقال...');
                
                // اضافه کردن token به URL برای اطمینان از لاگین موفق
                setTimeout(function() {
                    const token = data.token || localStorage.getItem('auth_token');
                    if (token) {
                        window.location.href = window.location.pathname + window.location.search + (window.location.search.includes('?') ? '&' : '?') + 'auth_token=' + token;
                    } else {
                        window.location.reload();
                    }
                }, 1500);
            }
        } else {
            showError('otp-error', data.message);
        }
    } catch (error) {
        showError('otp-error', 'خطا در ارتباط با سرور');
    } finally {
        btn.disabled = false;
        btn.innerHTML = '<i class="fas fa-check-circle"></i> تایید و ادامه';
    }
});

// Resend OTP
async function resendOTP() {
    const btn = document.getElementById('resendBtn');
    btn.disabled = true;
    btn.textContent = 'در حال ارسال...';
    
    try {
        const response = await fetch('/api/send-otp.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ phone: currentPhone })
        });
        
        const data = await response.json();
        
        if (data.status === 'ok') {
            showSuccess('otp-success', 'کد جدید ارسال شد');
            setTimeout(() => hideError('otp-success'), 3000);
            startTimer();
        } else {
            showError('otp-error', data.message);
        }
    } catch (error) {
        showError('otp-error', 'خطا در ارتباط با سرور');
    } finally {
        btn.textContent = 'ارسال مجدد کد';
    }
}

// eSIM Support Checkbox - Enable/Disable Payment Button
document.addEventListener('DOMContentLoaded', function() {
    const esimSupportCheckbox = document.getElementById('esimSupport');
    const paymentBtn = document.getElementById('paymentBtn');
    
    if (esimSupportCheckbox && paymentBtn) {
        esimSupportCheckbox.addEventListener('change', function() {
            if (this.checked) {
                paymentBtn.disabled = false;
                paymentBtn.style.background = 'linear-gradient(135deg, #10b981 0%, #059669 100%)';
            } else {
                paymentBtn.disabled = true;
                paymentBtn.style.background = '#94a3b8';
            }
        });
    }
});
</script>

<?php include __DIR__ . '/includes/footer.php'; ?>

